<?php
// 测试文件：test.php
require_once 'config.php';

// 1. 测试数据库
try {
    $conn = getDBConnection();
    echo "<p style='color:green'>✓ 数据库连接成功</p>";
    $conn->close();
} catch(Exception $e) {
    echo "<p style='color:red'>✗ 数据库错误: ".$e->getMessage()."</p>";
}

// 2. 测试上传目录
$uploadTestDir = "uploads/test_".time();
if (!mkdir($uploadTestDir, 0755, true)) {
    echo "<p style='color:red'>✗ 上传目录不可写</p>";
} else {
    echo "<p style='color:green'>✓ 上传目录可写</p>";
    rmdir($uploadTestDir);
}

// 3. 测试GD库
if (!extension_loaded('gd')) {
    echo "<p style='color:red'>✗ GD库未安装</p>";
} else {
    echo "<p style='color:green'>✓ GD库已安装</p>";
}

// 4. 测试会话
session_start();
$_SESSION['test'] = 'OK';
echo "<p style='color:green'>✓ 会话测试通过</p>";
?>