<?php
// 检查是否已安装
if (file_exists('../installed.lock')) {
    die('系统已安装，如需重新安装请删除 installed.lock 文件');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $dbHost = $_POST['db_host'] ?? 'localhost';
    $dbUser = $_POST['db_user'] ?? '';
    $dbPass = $_POST['db_pass'] ?? '';
    $dbName = $_POST['db_name'] ?? '';
    $adminUser = $_POST['admin_user'] ?? 'admin';
    $adminPass = $_POST['admin_pass'] ?? '123456';
    
    if (empty($dbUser) || empty($dbName) || empty($adminUser) || empty($adminPass)) {
        $error = '所有字段不能为空';
    } else {
        try {
            $conn = new mysqli($dbHost, $dbUser, $dbPass);
            if ($conn->connect_error) {
                throw new Exception("数据库连接失败: " . $conn->connect_error);
            }
            
            if (!$conn->query("CREATE DATABASE IF NOT EXISTS `$dbName` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci")) {
                throw new Exception("创建数据库失败: " . $conn->error);
            }
            
            $conn->select_db($dbName);
            
            $sqlFile = '1.sql';
            if (!file_exists($sqlFile)) {
                throw new Exception("SQL文件不存在");
            }
            
            $sql = file_get_contents($sqlFile);
            if (empty($sql)) {
                throw new Exception("SQL文件为空");
            }
            
            $sql = str_replace(
                ['{{ADMIN_USER}}', '{{ADMIN_PASS}}'], 
                [$adminUser, $adminPass], 
                $sql
            );
            
            if (!$conn->multi_query($sql)) {
                throw new Exception("导入SQL失败: " . $conn->error);
            }
            
            while ($conn->more_results()) {
                $conn->next_result();
            }
            
            $configContent = <<<EOT
<?php
define('DB_HOST', '$dbHost');
define('DB_USER', '$dbUser');
define('DB_PASS', '$dbPass');
define('DB_NAME', '$dbName');

function getDBConnection() {
    \$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if (\$conn->connect_error) {
        die("连接失败: " . \$conn->connect_error);
    }
    return \$conn;
}
EOT;
            
            if (!file_put_contents('../config.php', $configContent)) {
                throw new Exception("创建配置文件失败");
            }
            
            if (!file_exists('../uploads')) {
                mkdir('../uploads', 0777, true);
            }
            
            file_put_contents('../installed.lock', '安装时间: ' . date('Y-m-d H:i:s'));
            
            header('Location: ../admin/login.php');
            exit;
            
        } catch (Exception $e) {
            $error = $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>系统安装向导</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .install-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="install-container bg-white">
            <h2 class="text-center mb-4">系统安装向导</h2>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <form method="post">
                <h5 class="mt-4">数据库设置</h5>
                <div class="mb-3">
                    <label for="db_host" class="form-label">数据库地址</label>
                    <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                </div>
                <div class="mb-3">
                    <label for="db_user" class="form-label">数据库用户名</label>
                    <input type="text" class="form-control" id="db_user" name="db_user" required>
                </div>
                <div class="mb-3">
                    <label for="db_pass" class="form-label">数据库密码</label>
                    <input type="password" class="form-control" id="db_pass" name="db_pass">
                </div>
                <div class="mb-3">
                    <label for="db_name" class="form-label">数据库名</label>
                    <input type="text" class="form-control" id="db_name" name="db_name" required>
                </div>
                
                <h5 class="mt-4">管理员账号</h5>
                <div class="mb-3">
                    <label for="admin_user" class="form-label">管理员用户名</label>
                    <input type="text" class="form-control" id="admin_user" name="admin_user" value="admin" required>
                </div>
                <div class="mb-3">
                    <label for="admin_pass" class="form-label">管理员密码</label>
                    <input type="password" class="form-control" id="admin_pass" name="admin_pass" value="admin123" required>
                </div>
                
                <div class="d-grid mt-4">
                    <button type="submit" class="btn btn-primary btn-lg">开始安装</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>