<?php
require_once '../config.php';
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$conn = getDBConnection();
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>图片管理后台</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css">
    <style>
        :root {
            --sidebar-width: 280px;
            --primary-color: #6366f1;
            --secondary-color: #4f46e5;
            --dark-color: #1e293b;
            --light-color: #f8fafc;
        }
        
        body {
            background-color: var(--light-color);
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }
        
        /* 侧边栏样式 */
        .admin-sidebar {
            width: var(--sidebar-width);
            background: var(--dark-color);
            color: white;
            position: fixed;
            height: 100vh;
            transition: all 0.3s;
            z-index: 1000;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }
        
        .admin-main {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            transition: all 0.3s;
        }
        
        /* 导航链接 */
        .nav-link {
            color: rgba(255,255,255,0.7);
            padding: 0.75rem 1.5rem;
            margin: 0.25rem 1rem;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .nav-link:hover, .nav-link.active {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .nav-link.active {
            font-weight: 500;
        }
        
        /* 卡片样式 */
        .admin-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
            overflow: hidden;
        }
        
        .card-header {
            background: white;
            border-bottom: 1px solid rgba(0,0,0,0.05);
            font-weight: 600;
        }
        
        /* 表格样式 */
        .admin-table {
            --bs-table-bg: transparent;
        }
        
        .admin-table th {
            background: var(--primary-color);
            color: white;
            font-weight: 500;
            padding: 1rem;
        }
        
        .admin-table td {
            vertical-align: middle;
            padding: 1rem;
            border-color: rgba(0,0,0,0.03);
        }
        
        /* 图片预览 */
        .table-img {
            width: 80px;
            height: 80px;
            object-fit: cover;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        
        .table-img:hover {
            transform: scale(1.8);
            z-index: 10;
        }
        
        /* 按钮样式 */
        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
            border: none;
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            border: none;
        }
        
        /* 上传区域 */
        .upload-area {
            border: 2px dashed #ddd;
            border-radius: 12px;
            padding: 1.5rem;
            background: rgba(255,255,255,0.5);
            transition: all 0.3s;
        }
        
        .upload-area:hover {
            border-color: var(--primary-color);
            background: rgba(99, 102, 241, 0.05);
        }
        
        /* 移动端适配 */
        @media (max-width: 992px) {
            .admin-sidebar {
                left: calc(-1 * var(--sidebar-width));
            }
            
            .admin-main {
                margin-left: 0;
            }
            
            .sidebar-open .admin-sidebar {
                left: 0;
            }
            
            .sidebar-open .admin-main {
                transform: translateX(var(--sidebar-width));
            }
            
            .mobile-menu-btn {
                display: block !important;
            }
        }
    </style>
</head>
<body>
    <!-- 侧边栏 -->
    <?php include 'head.php'; ?>
    
    <!-- 主内容区 -->
    <main class="admin-main">
        <!-- 顶部导航 -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h2 class="mb-0"><i class="bi bi-images me-2"></i>图片管理</h2>
                <nav aria-label="breadcrumb" class="mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item active" aria-current="page">所有图片</li>
                    </ol>
                </nav>
            </div>
            
        </div>
        
        <!-- 上传卡片 (已移除验证码) -->
        <div class="admin-card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-cloud-upload me-2"></i>上传新图片</h5>
            </div>
            <div class="card-body">
                <form action="../upload.php" method="post" enctype="multipart/form-data">
                    <div class="upload-area text-center mb-3">
                        <i class="bi bi-cloud-arrow-up" style="font-size: 2rem; color: var(--primary-color);"></i>
                        <p class="mt-2 mb-1">拖放文件到此处或点击选择</p>
                        <p class="small text-muted">支持 JPG, PNG, GIF 格式，最大 5MB</p>
                        <input type="file" class="form-control mt-3" name="image" accept="image/*" required>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-upload me-1"></i> 开始上传
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <!-- 图片表格 -->
        <div class="admin-card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-collection me-2"></i>图片列表</h5>
                <span class="badge bg-primary">
                    <?php 
                    $count = $conn->query("SELECT COUNT(*) FROM images")->fetch_row()[0];
                    echo $count . ' 张图片';
                    ?>
                </span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table admin-table mb-0">
                        <thead>
                            <tr>
                                <th width="80">ID</th>
                                <th width="120">预览</th>
                                <th>路径</th>
                                <th width="180">上传时间</th>
                                <th width="120">操作</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $sql = "SELECT id, filename, upload_time FROM images ORDER BY upload_time DESC";
                            $result = $conn->query($sql);
                            
                            if ($result->num_rows > 0) {
                                while($row = $result->fetch_assoc()) {
                                    $imageUrl = "$baseUrl/uploads/" . $row['filename'];
                                    echo '<tr>
                                            <td>#'.$row['id'].'</td>
                                            <td>
                                                <img src="'.$imageUrl.'" class="table-img" 
                                                     data-bs-toggle="tooltip" data-bs-placement="top" 
                                                     title="点击查看大图" onclick="previewImage(\''.$imageUrl.'\')">
                                            </td>
                                            <td>
                                                <div class="input-group input-group-sm">
                                                    <input type="text" class="form-control" value="'.$imageUrl.'" readonly>
                                                    <button class="btn btn-outline-secondary" onclick="copyToClipboard(this)">
                                                        <i class="bi bi-clipboard"></i>
                                                    </button>
                                                </div>
                                            </td>
                                            <td>'.date('Y-m-d H:i', strtotime($row['upload_time'])).'</td>
                                            <td>
                                                <form method="post" action="delete.php" onsubmit="return confirm(\'确定删除这张图片吗？\')">
                                                    <input type="hidden" name="id" value="'.$row['id'].'">
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="bi bi-trash"></i> 删除
                                                    </button>
                                                </form>
                                            </td>
                                          </tr>';
                                }
                            } else {
                                echo '<tr>
                                        <td colspan="5" class="text-center py-5">
                                            <i class="bi bi-images" style="font-size: 2rem; opacity: 0.5;"></i>
                                            <p class="mt-3 text-muted">暂无图片，请上传第一张图片</p>
                                        </td>
                                      </tr>';
                            }
                            $conn->close();
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>

    <!-- 图片预览模态框 -->
    <div class="modal fade" id="imagePreviewModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">图片预览</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center p-0">
                    <img src="" id="previewImage" class="img-fluid" style="max-height: 80vh;">
                </div>
                <div class="modal-footer justify-content-center">
                    <a href="#" id="downloadBtn" class="btn btn-primary">
                        <i class="bi bi-download me-1"></i> 下载图片
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.getElementById('menuToggle').addEventListener('click', function() {
            document.body.classList.toggle('sidebar-open');
        });
        
        function previewImage(url) {
            const modal = new bootstrap.Modal(document.getElementById('imagePreviewModal'));
            document.getElementById('previewImage').src = url;
            document.getElementById('downloadBtn').href = url;
            document.getElementById('downloadBtn').setAttribute('download', url.split('/').pop());
            modal.show();
        }
        
        function copyToClipboard(button) {
            const input = button.closest('.input-group').querySelector('input');
            input.select();
            document.execCommand('copy');
            
            const icon = button.querySelector('i');
            icon.className = 'bi bi-check2';
            setTimeout(() => {
                icon.className = 'bi bi-clipboard';
            }, 2000);
        }
        
        const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    </script>
</body>
</html>