<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$currentPage = basename($_SERVER['PHP_SELF']);
?>
<nav class="navbar navbar-dark bg-dark d-md-none">
    <div class="container-fluid">
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#sidebar">
            <span class="navbar-toggler-icon"></span> <!-- 三道杠图标 -->
        </button>
        <span class="navbar-brand">管理后台</span>
    </div>
</nav>

<div class="offcanvas offcanvas-start bg-dark text-white" tabindex="-1" id="sidebar">
    <div class="offcanvas-header">
        <h5 class="offcanvas-title">图片管理系统</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
    </div>
    <div class="offcanvas-body p-0">
        <div class="p-3">
            <div class="small">欢迎，<?php echo htmlspecialchars($_SESSION['admin_username']); ?></div>
        </div>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'index.php'? 'active' : ''; ?>" href="index.php">
                    <i class="bi bi-images"></i> 图片管理
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'change_password.php'? 'active' : ''; ?>" href="change_password.php">
                    <i class="bi bi-key"></i> 修改密码
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="logout.php?logout=success">
                    <i class="bi bi-box-arrow-right"></i> 退出登录
                </a>
            </li>
        </ul>
    </div>
</div>

<div class="d-none d-md-block col-md-2 sidebar p-0">
    <div class="p-3 text-white">
        <h5>图片管理系统</h5>
        <div class="small">欢迎，<?php echo htmlspecialchars($_SESSION['admin_username']); ?></div>
    </div>
    <ul class="nav flex-column">
        <li class="nav-item">
            <a class="nav-link <?php echo $currentPage === 'index.php'? 'active' : ''; ?>" href="index.php">
                <i class="bi bi-images"></i> 图片管理
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo $currentPage === 'change_password.php'? 'active' : ''; ?>" href="change_password.php">
                <i class="bi bi-key"></i> 修改密码
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="logout.php">
                <i class="bi bi-box-arrow-right"></i> 退出登录
            </a>
        </li>
    </ul>
</div>

<style>
   .nav-link.active {
        color: blue; /* 激活状态的链接颜色为蓝色 */
    }
   .nav-link {
        color: white; /* 非激活状态的链接颜色为白色 */
    }
</style>
