<?php
require_once '../config.php';
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    header('Location: login.php');
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currentUsername = $_SESSION['admin_username'];
    $currentPassword = $_POST['current_password'] ?? '';
    $newUsername = $_POST['new_username'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    if (empty($currentPassword) || empty($newPassword) || empty($confirmPassword)) {
        $error = '所有字段不能为空';
    } elseif ($newPassword!== $confirmPassword) {
        $error = '两次输入的新密码不一致';
    } else {
        $conn = getDBConnection();
        $stmt = $conn->prepare("SELECT id, password FROM admin_users WHERE username =?");
        $stmt->bind_param("s", $currentUsername);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            
            if ($currentPassword === $user['password']) {

                $updateSql = "UPDATE admin_users SET username =?, password =? WHERE id =?";
                $stmt = $conn->prepare($updateSql);
                $newUsername =!empty($newUsername)? $newUsername : $currentUsername;
                $stmt->bind_param("ssi", $newUsername, $newPassword, $user['id']);
                
                if ($stmt->execute()) {
                    $_SESSION['admin_username'] = $newUsername;
                    $success = '密码修改成功，请重新登录';
                    session_destroy();
                    header('Location: login.php?success='. urlencode($success));
                    exit;
                } else {
                    $error = '密码修改失败';
                }
            } else {
                $error = '当前密码错误';
            }
        } else {
            $error = '用户不存在';
        }
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>修改密码</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.0/font/bootstrap-icons.css">
    <style>
       .password-container {
            max-width: 500px;
            margin: 50px auto;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'head.php';?>
            
            <div class="col-md-10 main-content">
                <div class="password-container bg-white">
                    <h2 class="mb-4"><i class="bi bi-key"></i> 修改密码</h2>
                    
                    <?php if ($error):?>
                        <div class="alert alert-danger"><?php echo htmlspecialchars($error);?></div>
                    <?php endif;?>
                    
                    <form method="post">
                        <div class="mb-3">
                            <label for="current_password" class="form-label">当前密码</label>
                            <input type="password" class="form-control" id="current_password" name="current_password" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_username" class="form-label">新用户名 (可选)</label>
                            <input type="text" class="form-control" id="new_username" name="new_username" 
                                   placeholder="不修改请留空" value="<?php echo htmlspecialchars($_SESSION['admin_username']?? '');?>">
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_password" class="form-label">新密码</label>
                            <input type="password" class="form-control" id="new_password" name="new_password" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="confirm_password" class="form-label">确认新密码</label>
                            <input type="password" class="form-control" id="confirm_password" name="confirm_password" required>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">确认修改</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
