<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $conf['wall_guide_title']?$conf['wall_guide_title']:'网站引导页';?></title>
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: -apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,"Noto Sans",sans-serif;
            background: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .container {
            background: #fff;
            padding: 2rem;
            border-radius: 10px;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,.15);
            text-align: center;
            max-width: 90%;
            width: 500px;
        }
        .title {
            font-size: 1.5rem;
            color: #333;
            margin-bottom: 1rem;
        }
        .content {
            color: #666;
            line-height: 1.6;
            margin-bottom: 2rem;
        }
        .btn {
            display: inline-block;
            padding: .5rem 1.5rem;
            font-size: 1rem;
            font-weight: 500;
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
            transition: background-color .15s ease-in-out;
        }
        .btn:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="title"><?php echo $conf['wall_guide_title']?$conf['wall_guide_title']:'欢迎访问';?></h1>
        <div class="content"><?php echo $conf['wall_guide_content']?$conf['wall_guide_content']:'点击下方按钮继续访问网站';?></div>
        <a href="javascript:;" onclick="continueVisit()" class="btn"><?php echo $conf['wall_guide_btn']?$conf['wall_guide_btn']:'继续访问';?></a>
    </div>
    <script>
    function continueVisit() {
        // 设置cookie,有效期24小时
        var exp = new Date();
        exp.setTime(exp.getTime() + 24*60*60*1000);
        document.cookie = "wall_guide=1;path=/;expires=" + exp.toGMTString();
        window.location.reload();
    }
    </script>
</body>
</html> 