<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>域名更换通知</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="//cdn.staticfile.org/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Microsoft YaHei', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: #f8f9fa;
            color: #333;
            line-height: 1.6;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            padding: 40px;
            max-width: 600px;
            width: 100%;
            text-align: center;
            animation: fadeIn 0.5s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .icon {
            font-size: 48px;
            color: #3498db;
            margin-bottom: 20px;
        }
        h1 {
            color: #2c3e50;
            font-size: 24px;
            margin-bottom: 20px;
            font-weight: 600;
        }
        .domain-info {
            background: #f8f9fa;
            border-radius: 12px;
            padding: 20px;
            margin: 20px 0;
            text-align: left;
        }
        .domain-row {
            display: flex;
            align-items: center;
            margin: 10px 0;
            padding: 10px;
            border-radius: 8px;
            background: #fff;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }
        .domain-label {
            color: #666;
            width: 100px;
            flex-shrink: 0;
        }
        .domain-value {
            color: #2c3e50;
            font-weight: 500;
            word-break: break-all;
        }
        .notice {
            color: #e74c3c;
            font-size: 14px;
            margin: 20px 0;
            padding: 10px;
            border-radius: 8px;
            background: #fff5f5;
        }
        .progress-container {
            margin: 30px 0;
            background: #eee;
            border-radius: 10px;
            height: 6px;
            overflow: hidden;
        }
        .progress-bar {
            width: 0%;
            height: 100%;
            background: linear-gradient(90deg, #3498db, #2ecc71);
            animation: progress 2s linear forwards;
        }
        @keyframes progress {
            from { width: 0%; }
            to { width: 100%; }
        }
        .arrow {
            color: #3498db;
            font-size: 24px;
            margin: 0 10px;
        }
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <i class="fa fa-globe icon"></i>
        <h1>域名更换通知</h1>
        
        <div class="domain-info">
            <div class="domain-row">
                <span class="domain-label">当前域名：</span>
                <span class="domain-value"><?php echo htmlspecialchars($current_domain); ?></span>
            </div>
            <div class="domain-row">
                <span class="domain-label">新域名：</span>
                <span class="domain-value"><?php echo htmlspecialchars($new_domain); ?></span>
            </div>
        </div>

        <div class="notice">
            <i class="fa fa-exclamation-circle"></i> 
            提示：当前域名已停用，请使用新域名访问。建议收藏新域名地址，避免后续访问不便。
        </div>

        <div class="progress-container">
            <div class="progress-bar"></div>
        </div>

        <p><span class="loading"></span> 正在自动跳转到新域名，请稍候...</p>
    </div>

    <script>
        setTimeout(function(){
            window.location.href = <?php echo json_encode($new_url); ?>;
        }, 2000);
    </script>
</body>
</html> 