<?php
include("../includes/common.php");
$title='数据库更新';
include './head.php';
if($islogin==1){}else exit("<script language='javascript'>window.location.href='./login.php';</script>");

$success = 0;
$error = '';
$msg = '';

// 获取当前数据库版本号
include 'version.config.php';

// 更新数据库版本号
$stmt = $DB->query("SELECT v FROM pre_config WHERE k='db_version'");
if($stmt->fetch()) {
    if($DB->exec("UPDATE pre_config SET v='{$current_db_version}' WHERE k='db_version'") !== false) {
        $success++;
        $msg .= '成功更新数据库版本到 '.$current_db_version.'<br/>';
    } else {
        $error .= '更新数据库版本失败['.$DB->error().']<br/>';
    }
} else {
    if($DB->exec("INSERT INTO pre_config SET k='db_version',v='{$current_db_version}'") !== false) {
        $success++;
        $msg .= '成功添加数据库版本记录<br/>';
    } else {
        $error .= '添加数据库版本记录失败['.$DB->error().']<br/>';
    }
}

// 检查pre_sync_config表是否存在
$stmt = $DB->query("SHOW TABLES LIKE 'pre_sync_config'");
$table_exists = $stmt->fetch();
if(!$table_exists){
    // 创建同步配置表
    $sql = "CREATE TABLE `pre_sync_config` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `shequ_id` int(11) NOT NULL,
        `sync_interval` int(11) NOT NULL DEFAULT '5',
        `sync_limit` int(11) NOT NULL DEFAULT '50',
        `auto_update` tinyint(1) NOT NULL DEFAULT '1',
        `delete_rule` tinyint(1) NOT NULL DEFAULT '0',
        `sync_class` tinyint(1) NOT NULL DEFAULT '1',
        `sync_sort` tinyint(1) NOT NULL DEFAULT '1',
        `sync_log` tinyint(1) NOT NULL DEFAULT '1',
        `sync_name` tinyint(1) NOT NULL DEFAULT '1',
        `sync_price` tinyint(1) NOT NULL DEFAULT '1',
        `sync_cost` tinyint(1) NOT NULL DEFAULT '1',
        `sync_desc` tinyint(1) NOT NULL DEFAULT '1',
        `sync_image` tinyint(1) NOT NULL DEFAULT '1',
        `add_class` tinyint(1) NOT NULL DEFAULT '0',
        `add_goods` tinyint(1) NOT NULL DEFAULT '0',
        `markup_template` int(11) NOT NULL DEFAULT '0',
        `status` tinyint(1) NOT NULL DEFAULT '0',
        `addtime` datetime DEFAULT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `shequ_id` (`shequ_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    if($DB->exec($sql) !== false){
        $success++;
        $msg .= '成功创建数据表pre_sync_config<br/>';
    }else{
        $error .= '创建数据表pre_sync_config失败['.$DB->error().']<br/>';
    }
}else{
    // 检查是否需要添加新字段
    $columns = $DB->query("SHOW COLUMNS FROM pre_sync_config")->fetchAll();
    $column_names = array_column($columns, 'Field');
    
    // 检查sync_sort字段
    if(!in_array('sync_sort', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN sync_sort tinyint(1) NOT NULL DEFAULT 1") !== false){
            $success++;
            $msg .= '成功添加字段sync_sort<br/>';
        }else{
            $error .= '添加字段sync_sort失败['.$DB->error().']<br/>';
        }
    }
    
    // 检查add_class字段
    if(!in_array('add_class', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN add_class tinyint(1) NOT NULL DEFAULT 0") !== false){
            $success++;
            $msg .= '成功添加字段add_class<br/>';
        }else{
            $error .= '添加字段add_class失败['.$DB->error().']<br/>';
        }
    }
    
    // 检查add_goods字段
    if(!in_array('add_goods', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN add_goods tinyint(1) NOT NULL DEFAULT 0") !== false){
            $success++;
            $msg .= '成功添加字段add_goods<br/>';
        }else{
            $error .= '添加字段add_goods失败['.$DB->error().']<br/>';
        }
    }
    
    // 检查markup_template字段
    if(!in_array('markup_template', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN markup_template int(11) NOT NULL DEFAULT 0") !== false){
            $success++;
            $msg .= '成功添加字段markup_template<br/>';
        }else{
            $error .= '添加字段markup_template失败['.$DB->error().']<br/>';
        }
    }
    
    // 检查sync_log字段
    if(!in_array('sync_log', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN sync_log tinyint(1) NOT NULL DEFAULT 1") !== false){
            $success++;
            $msg .= '成功添加字段sync_log<br/>';
        }else{
            $error .= '添加字段sync_log失败['.$DB->error().']<br/>';
        }
    }
    
    // 检查sync_goods_sort字段
    if(!in_array('sync_goods_sort', $column_names)){
        if($DB->exec("ALTER TABLE pre_sync_config ADD COLUMN sync_goods_sort tinyint(1) NOT NULL DEFAULT 1") !== false){
            $success++;
            $msg .= '成功添加字段sync_goods_sort<br/>';
        }else{
            $error .= '添加字段sync_goods_sort失败['.$DB->error().']<br/>';
        }
    }
}

// 检查last_sync_time配置项
$stmt = $DB->query("SELECT v FROM pre_config WHERE k='last_sync_time'");
if(!$stmt->fetch()){
    if($DB->exec("INSERT INTO pre_config SET k='last_sync_time',v=''") !== false){
        $success++;
        $msg .= '成功添加配置项last_sync_time<br/>';
    }else{
        $error .= '添加配置项last_sync_time失败['.$DB->error().']<br/>';
    }
}

// 添加防墙引导页相关配置
$configs = array(
    'wall_guide_open' => '0',
    'wall_guide_title' => '网站访问提示',
    'wall_guide_content' => '欢迎访问本站,请遵守相关法律法规',
    'wall_guide_btn' => '继续访问'
);

foreach($configs as $k => $v){
    $stmt = $DB->query("SELECT v FROM pre_config WHERE k='$k'");
    if(!$stmt->fetch()){
        if($DB->exec("INSERT INTO pre_config SET k='$k',v='$v'") !== false){
            $success++;
            $msg .= "成功添加配置项{$k}<br/>";
        }else{
            $error .= "添加配置项{$k}失败[".$DB->error()."]<br/>";
        }
    }
}

// 更新CDN配置为今日头条CDN
$stmt = $DB->query("SELECT v FROM pre_config WHERE k='cdnpublic'");
if($stmt->fetch()){
    if($DB->exec("UPDATE pre_config SET v='4' WHERE k='cdnpublic'") !== false){
        saveSetting('cdnpublic', '4');
        $CACHE->clear();
        $success++;
        $msg .= '成功更新CDN配置为今日头条CDN<br/>';
    }else{
        $error .= '更新CDN配置失败['.$DB->error().']<br/>';
    }
}else{
    if($DB->exec("INSERT INTO pre_config SET k='cdnpublic',v='4'") !== false){
        saveSetting('cdnpublic', '4');
        $CACHE->clear();
        $success++;
        $msg .= '成功添加CDN配置并设置为今日头条CDN<br/>';
    }else{
        $error .= '添加CDN配置失败['.$DB->error().']<br/>';
    }
}

// 检查pre_parent_class表是否存在
$stmt = $DB->query("SHOW TABLES LIKE 'pre_parent_class'");
$table_exists = $stmt->fetch();
if(!$table_exists){
    // 创建一级分类表
    $sql = "CREATE TABLE IF NOT EXISTS `pre_parent_class` (
        `cid` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(255) NOT NULL,
        `sort` int(11) NOT NULL DEFAULT '10',
        `addtime` datetime DEFAULT NULL,
        PRIMARY KEY (`cid`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
    
    if($DB->exec($sql) !== false){
        $success++;
        $msg .= '成功创建数据表pre_parent_class<br/>';
    }else{
        $error .= '创建数据表pre_parent_class失败['.$DB->error().']<br/>';
    }
}

// 检查pre_class表是否有parent_cid字段
$columns = $DB->query("SHOW COLUMNS FROM pre_class")->fetchAll();
$column_names = array_column($columns, 'Field');
if(!in_array('parent_cid', $column_names)){
    if($DB->exec("ALTER TABLE `pre_class` ADD COLUMN `parent_cid` int(11) NOT NULL DEFAULT '0' COMMENT '一级分类ID' AFTER `cid`") !== false){
        $success++;
        $msg .= '成功添加字段parent_cid到pre_class表<br/>';
    }else{
        $error .= '添加字段parent_cid到pre_class表失败['.$DB->error().']<br/>';
    }
}
?>

<div class="col-xs-12 col-sm-10 col-lg-8 center-block" style="float: none;">
    <div class="block">
        <div class="block-title"><h3 class="panel-title">数据库更新</h3></div>
        <div class="card">
            <div class="card-body">
                <?php
                if($error){
                    echo '<div class="alert alert-danger">';
                    echo '<strong>失败!</strong><br/>';
                    echo $error;
                    echo '</div>';
                }
                if($success > 0){
                    echo '<div class="alert alert-success">';
                    echo '<strong>成功!</strong><br/>';
                    echo $msg;
                    echo '</div>';
                }
                if(!$error && $success == 0){
                    echo '<div class="alert alert-info">';
                    echo '<strong>提示:</strong><br/>';
                    echo '数据库结构已经是最新版本,无需更新!<br/>';
                    echo '</div>';
                }
                ?>
                <hr/>
                <a href="./index.php" class="btn btn-default btn-block">返回首页</a>
            </div>
        </div>
    </div>
</div>
</div></div>
<?php include './foot.php';?> 